/*********************************************************************
 *
 * Copyright:
 *	1999-2000 MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

/*
 * File:		io.c
 * Purpose:		Serial Input/Output routines
 *
 */

#include "mcf5282.h"
#include "init.h"

/********************************************************************/
int
in_char (void)
{
	/* Wait until character has been received */
	while (!(MCF5282_UART0_USR & MCF5282_UART_USR_RXRDY))
		; 
	return MCF5282_UART0_URB;
}
/********************************************************************/
void
out_char (int ch)
{
	/* Wait until space is available in the FIFO */
	while (!(MCF5282_UART0_USR & MCF5282_UART_USR_TXRDY))
		;
	/* Send the character */
	MCF5282_UART0_UTB = ch;
}

/********************************************************************/
int
uart0_char_present (void)
{
	return (MCF5282_UART0_USR & MCF5282_UART_USR_RXRDY);
}

/********************************************************************/
char
uart1_in_char (void)
{
	/* Wait until character has been received */
	while (!(MCF5282_UART1_USR & MCF5282_UART_USR_RXRDY))
		; 
	return MCF5282_UART1_URB;
}
/********************************************************************/
void
uart1_out_char (char ch)
{
	/* Wait until space is available in the FIFO */
	while (!(MCF5282_UART1_USR & MCF5282_UART_USR_TXRDY))
		;
	/* Send the character */
	MCF5282_UART1_UTB = ch;
}

/********************************************************************/
int
uart1_char_present (void)
{
	return (MCF5282_UART1_USR & MCF5282_UART_USR_RXRDY);
}

/********************************************************************/
char
uart2_in_char (void)
{
	/* Wait until character has been received */
	while (!(MCF5282_UART2_USR & MCF5282_UART_USR_RXRDY))
		; 
	return MCF5282_UART2_URB;
}
/********************************************************************/
void
uart2_out_char (char ch)
{
	/* Wait until space is available in the FIFO */
	while (!(MCF5282_UART2_USR & MCF5282_UART_USR_TXRDY))
		;
	/* Send the character */
	MCF5282_UART2_UTB = ch;
}

/********************************************************************/
int
uart2_char_present (void)
{
	return (MCF5282_UART2_USR & MCF5282_UART_USR_RXRDY);
}

/********************************************************************/